/* Arduino SdFat Library
 * Copyright (C) 2010 by William Greiman
 *
 * This file is part of the Arduino SdFat Library
 *
 * This Library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the Arduino SdFat Library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */


// Note: If you use the SD library, You need to insert below definitions to your "arduino\libraries\SD\utility\Sd2PinMap.h".
// ja: ご注意：SD ライブラリを使用する場合は、"arduino\libraries\SD\utility\Sd2PinMap.h" に、以下の定義を追加して下さい。


#elif defined(__AVR_ATmega1284P_UNO1284P__)
// Uno1284P

// Two Wire (aka I2C) ports
uint8_t const SDA_PIN = 17;
uint8_t const SCL_PIN = 16;

// SPI port
uint8_t const SS_PIN   = 10;
uint8_t const MOSI_PIN = 11;
uint8_t const MISO_PIN = 12;
uint8_t const SCK_PIN  = 13;

static const pin_map_t digitalPinMap[] = {
  {&DDRD, &PIND, &PORTD, 0},  // D0  0
  {&DDRD, &PIND, &PORTD, 1},  // D1  1
  {&DDRD, &PIND, &PORTD, 2},  // D2  2
  {&DDRD, &PIND, &PORTD, 3},  // D3  3
  {&DDRD, &PIND, &PORTD, 7},  // D7  4

  {&DDRB, &PINB, &PORTB, 4},  // B4  5
  {&DDRB, &PINB, &PORTB, 3},  // B3  6
  {&DDRB, &PINB, &PORTB, 2},  // B2  7

  {&DDRD, &PIND, &PORTD, 6},  // D6  8
  {&DDRD, &PIND, &PORTD, 5},  // D5  9
  {&DDRD, &PIND, &PORTD, 4},  // D4 10

  {&DDRB, &PINB, &PORTB, 5},  // B5 11
  {&DDRB, &PINB, &PORTB, 6},  // B6 12
  {&DDRB, &PINB, &PORTB, 7},  // B7 13
  {&DDRB, &PINB, &PORTB, 0},  // B0 14
  {&DDRB, &PINB, &PORTB, 1},  // B1 15

  {&DDRC, &PINC, &PORTC, 0},  // C0 16
  {&DDRC, &PINC, &PORTC, 1},  // C1 17
  {&DDRC, &PINC, &PORTC, 2},  // C2 18
  {&DDRC, &PINC, &PORTC, 3},  // C3 19
  {&DDRC, &PINC, &PORTC, 4},  // C4 20
  {&DDRC, &PINC, &PORTC, 5},  // C5 21
  {&DDRC, &PINC, &PORTC, 6},  // C6 22
  {&DDRC, &PINC, &PORTC, 7},  // C7 23

  {&DDRA, &PINA, &PORTA, 0},  // A0 24
  {&DDRA, &PINA, &PORTA, 1},  // A1 25
  {&DDRA, &PINA, &PORTA, 2},  // A2 26
  {&DDRA, &PINA, &PORTA, 3},  // A3 27
  {&DDRA, &PINA, &PORTA, 6},  // A6 28
  {&DDRA, &PINA, &PORTA, 7},  // A7 29
  {&DDRA, &PINA, &PORTA, 4},  // A4 30
  {&DDRA, &PINA, &PORTA, 5},  // A5 31
};
//------------------------------------------------------------------------------

