/*
  PWM pins definition

  created 30/jan/2013 by I.Kato @ BS21 Lab

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General
  Public License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place, Suite 330,
  Boston, MA  02111-1307  USA
*/


#ifndef PWM_pins_h
#define PWM_pins_h


#if defined(__AVR_ATmega1280__) || defined(__AVR_ATmega2560__)
// Mega

const static uint8_t PWM2  =  2;
const static uint8_t PWM3  =  3;
const static uint8_t PWM4  =  4;
const static uint8_t PWM5  =  5;
const static uint8_t PWM6  =  6;
const static uint8_t PWM7  =  7;
const static uint8_t PWM8  =  8;
const static uint8_t PWM9  =  9;
const static uint8_t PWM10 = 10;
const static uint8_t PWM11 = 11;
const static uint8_t PWM12 = 12;
const static uint8_t PWM13 = 13;


#elif defined(__AVR_ATmega1284P_UNO1284P__)
// Uno1284P

const static uint8_t PWM3  =  4; // redirect to PWM4
const static uint8_t PWM4  =  4; // OC2A ( 8bit PWM)
const static uint8_t PWM5  =  5; // OC0B ( 8bit PWM)
const static uint8_t PWM6  =  6; // OC0A ( 8bit PWM)
const static uint8_t PWM8  =  8; // OC2B ( 8bit PWM)
const static uint8_t PWM9  =  9; // OC1A (16bit PWM)
const static uint8_t PWM10 = 10; // OC1B (16bit PWM)
const static uint8_t PWM11 =  8; // redirect to PWM8
const static uint8_t PWM12 = 12; // OC3A (16bit PWM)
const static uint8_t PWM13 = 13; // OC3B (16bit PWM)


#elif defined(__AVR_ATmega32U4__)
// Leonardo

const static uint8_t PWM3  =  3; // OC0B ( 8bit PWM)
const static uint8_t PWM5  =  5; // OC3A (??bit PWM)
const static uint8_t PWM6  =  6; // OC4D (??bit PWM)
const static uint8_t PWM9  =  9; // OC1A (16bit PWM)
const static uint8_t PWM10 = 10; // OC1B (16bit PWM)
const static uint8_t PWM11 = 11; // OC0A ( 8bit PWM)
const static uint8_t PWM13 = 13; // OC4A (10bit PWM)


#else
// standard

const static uint8_t PWM3  =  3; // OC2B ( 8bit PWM)
const static uint8_t PWM5  =  5; // OC0B ( 8bit PWM)
const static uint8_t PWM6  =  6; // OC0A ( 8bit PWM)
const static uint8_t PWM9  =  9; // OC1A (16bit PWM)
const static uint8_t PWM10 = 10; // OC1B (16bit PWM)
const static uint8_t PWM11 = 11; // OC2A ( 8bit PWM)


#endif


#endif // PWM_pins_h

